<!doctype html>
<html lang="en">

<head>
    <!-- Required meta tags -->
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>@lang('purchase::app.menu.inventory') - {{ $inventory->id }}</title>
    <meta name="msapplication-TileColor" content="#ffffff">
    <meta name="msapplication-TileImage" content="{{ $company->favicon_url }}">
    <meta name="theme-color" content="#ffffff">
    @includeIf('invoices.pdf.invoice_pdf_css')
    <style>
        .bg-grey {
            background-color: #F2F4F7;
        }

        .bg-white {
            background-color: #fff;
        }

        .border-radius-25 {
            border-radius: 0.25rem;
        }

        .p-25 {
            padding: 1.25rem;
        }

        .f-11 {
            font-size: 11px;
        }

        .f-12 {
            font-size: 12px;
        }

        .f-13 {
            font-size: 13px;
        }

        .f-14 {
            font-size: 13px;
        }

        .f-15 {
            font-size: 13px;
        }

        .f-21 {
            font-size: 17px;
        }

        .text-black {
            color: #28313c;
        }

        .text-grey {
            color: #616e80;
        }

        .font-weight-700 {
            font-weight: 700;
        }

        .text-uppercase {
            text-transform: uppercase;
        }

        .text-capitalize {
            text-transform: capitalize;
        }

        .line-height {
            line-height: 15px;
        }

        .mt-1 {
            margin-top: 1rem;
        }

        .mb-0 {
            margin-bottom: 0px;
        }

        .b-collapse {
            border-collapse: collapse;
        }

        .heading-table-left {
            padding: 6px;
            border: 1px solid #DBDBDB;
            font-weight: bold;
            background-color: #f1f1f3;
            border-right: 0;
        }

        .heading-table-right {
            padding: 6px;
            border: 1px solid #DBDBDB;
            border-left: 0;
        }

        .unpaid {
            color: #d30000;
            border: 1px solid #d30000;
            position: relative;
            padding: 5px 10px;
            font-size: 14px;
            border-radius: 0.25rem;
            width: 100px;
            text-align: center;
            margin-top: 50px;
        }

        .other {
            color: #000000;
            border: 1px solid #000000;
            position: relative;
            padding: 5px 10px;
            font-size: 14px;
            border-radius: 0.25rem;
            width: 120px;
            text-align: center;
            margin-top: 50px;
        }

        .paid {
            color: #28a745 !important;
            border: 1px solid #28a745;
            position: relative;
            padding: 6px 12px;
            font-size: 14px;
            border-radius: 0.25rem;
            width: 100px;
            text-align: center;
            margin-top: 50px;
        }

        .main-table-heading {
            border: 1px solid #DBDBDB;
            background-color: #f1f1f3;
            font-weight: 700;
        }

        .main-table-heading td {
            padding: 5px 8px;
            border: 1px solid #DBDBDB;
            font-size: 13px;
        }

        .main-table-items td {
            padding: 5px 8px;
            border: 1px solid #e7e9eb;
        }

        .total-box {
            border: 1px solid #e7e9eb;
            padding: 0px;
            border-bottom: 0px;
        }

        .subtotal {
            padding: 5px 8px;
            border: 1px solid #e7e9eb;
            border-top: 0;
            border-left: 0;
            border-right: 0;
        }

        .subtotal-amt {
            padding: 5px 8px;
            border: 1px solid #e7e9eb;
            border-top: 0;
            border-left: 0;
            border-right: 0;
        }

        .total {
            padding: 5px 8px;
            border: 1px solid #e7e9eb;
            border-top: 0;
            font-weight: 700;
            border-left: 0;
            border-right: 0;
        }

        .total-amt {
            padding: 5px 8px;
            border: 1px solid #e7e9eb;
            border-top: 0;
            border-left: 0;
            border-right: 0;
            font-weight: 700;
        }

        .balance {
            font-size: 14px;
            font-weight: bold;
            background-color: #f1f1f3;
        }

        .balance-left {
            padding: 5px 8px;
            border: 1px solid #e7e9eb;
            border-top: 0;
            border-left: 0;
            border-right: 0;
        }

        .balance-right {
            padding: 5px 8px;
            border: 1px solid #e7e9eb;
            border-top: 0;
            border-left: 0;
            border-right: 0;
        }

        .centered {
            margin: 0 auto;
        }

        .rightaligned {
            margin-right: 0;
            margin-left: auto;
        }

        .leftaligned {
            margin-left: 0;
            margin-right: auto;
        }

        .page_break {
            page-break-before: always;
        }

        #logo {
            height: 50px;
        }

        .word-break {
            max-width: 175px;
            word-wrap: break-word;
        }

        .summary {
            padding: 11px 10px;
            border: 1px solid #e7e9eb;
            font-size: 11px;
        }

        .border-left-0 {
            border-left: 0 !important;
        }

        .border-right-0 {
            border-right: 0 !important;
        }

        .border-top-0 {
            border-top: 0 !important;
        }

        .border-bottom-0 {
            border-bottom: 0 !important;
        }
        .h3-border {
            border-bottom: 1px solid #AAAAAA;
        }
</style>
    @if($invoiceSetting->locale == 'th')
    <style>

            table td {
            font-weight: bold !important;
            font-size: 20px !important;
        }

        .description {
            font-weight: bold !important;
            font-size: 16px !important;
        }


    </style>
@endif
</head>

<body class="content-wrapper">
    <table class="bg-white" border="0" cellpadding="0" cellspacing="0" width="100%" role="presentation">
        <tbody>
        <!-- Table Row Start -->
        <tr>
            <td><img src="{{ $invoiceSetting->logo_url }}" alt="{{ mb_ucwords($company->company_name) }}"
                    id="logo"/></td>
            <td align="right" class="f-21 text-black font-weight-700 text-uppercase">@lang('purchase::app.menu.inventory')<br>
                <table class="text-black mt-1 f-11 b-collapse rightaligned">
                    <tr>
                        <td class="heading-table-left">@lang('purchase::modules.inventory.inventoryNumber')</td>
                        <td class="heading-table-right">#{{ $inventory->id }}</td>
                    </tr>
                    <tr>
                        <td class="heading-table-left">@lang('purchase::modules.inventory.inventoryDate')</td>
                        <td class="heading-table-right">
                            {{ $inventory->date ? $inventory->date->translatedFormat($company->date_format) : '--' }}
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
        <!-- Table Row End -->
        <!-- Table Row Start -->
        <tr>
            <td class="f-12 text-black">
                <p class="line-height mb-0 ">
                    <span class="text-grey text-capitalize">@lang('purchase::modules.inventory.companyDetail')</span><br>
                    @if ($company && $company->company_name)
                        {{ $company->company_name }}<br>
                    @endif
                    @if ($company && $company->company_email)
                        {{ $company->company_email }}<br>
                    @endif
                    @if ($company && $company->address)
                        {{ $company->address }}<br>
                    @endif
                    @if ($company && $company->company_phone)
                        {{ $company->company_phone }}<br>
                    @endif
                </p>
            </td>
        </tr>
        <!-- Table Row End -->
        <!-- Table Row Start -->
        <tr>
            <td height="10"></td>
        </tr>
        <!-- Table Row End -->
        </tbody>
    </table>

    <table width="100%" class="f-14 b-collapse">
        <tr>
            <td height="10" colspan="2"></td>
        </tr>
        <!-- Table Row Start -->
        <tr class="main-table-heading text-grey">
            <td width="40%">@lang('purchase::app.itemName')</td>
            @if ($inventory->type == 'quantity')
                <td align="right">@lang('purchase::modules.product.quantityOnHand')</td>
                <td align="right">@lang('purchase::modules.product.quabtityAdjusted')</td>
            @else
                <td align="right">@lang('purchase::modules.product.changedValue')</td>
                <td align="right">@lang('purchase::modules.product.adjustedValue')</td>
            @endif
            <td align="right">@lang('app.status')</td>
        </tr>
        <!-- Table Row End -->
        @foreach ($inventory->stocks as $item)
            <!-- Table Row Start -->
            <tr class="f-12 main-table-items text-black">
                <td class="pl-2">{{ $item->product ? ($item->product->name) : '--' }}</td>
                @if ($inventory->type == 'quantity')
                    <td align="right">{{ $item->net_quantity }}</td>
                    <td align="right">{{ $item->quantity_adjustment }}</td>
                @else
                    <td align="right">{{ $item->changed_value }}</td>
                    <td align="right">{{ $item->adjusted_value }}</td>
                @endif
                <td align="right"><span class="badge @if ($item->status == 'draft') badge-secondary @else badge-success @endif username-badge">{{ $item->status }}</span></td>
            </tr>
        @endforeach

    </table>

    <p>
        <div style="margin-top: 10px;" class="f-11 line-height text-grey">
            <b>@lang('modules.invoiceSettings.invoiceTerms')</b><br>{!! nl2br($invoiceSetting->invoice_terms) !!}
        </div>
    </p>

</body>

</html>
