<?php

namespace Modules\LanguagePack\Providers;

use Illuminate\Support\Facades\Blade;
use Illuminate\Support\ServiceProvider;
use Modules\LanguagePack\Console\PublishTranslationCommand;

class LanguagePackServiceProvider extends ServiceProvider
{

    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = false;

    /**
     * Boot the application events.
     *
     * @return void
     */
    public function boot()
    {
        $this->registerTranslations();
        $this->registerConfig();
        $this->registerViews();
        $this->loadMigrationsFrom(__DIR__.'/../Database/Migrations');
        Blade::componentNamespace('Modules\\LanguagePack\\Views\\Components', 'languagepack');
        $this->commands([
            PublishTranslationCommand::class
        ]);
    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        $this->app->register(RouteServiceProvider::class);
    }

    /**
     * Register config.
     *
     * @return void
     */
    protected function registerConfig()
    {
        $this->publishes([
            __DIR__.'/../Config/config.php' => config_path('languagepack.php'),
        ]);

        $this->mergeConfigFrom(
            __DIR__.'/../Config/config.php', 'languagepack'
        );


        $this->mergeConfigFrom(
            module_path('languagepack', 'Config/xss_ignore.php'),
            'languagepack::xss_ignore'
        );
    }

    /**
     * Register views.
     *
     * @return void
     */
    public function registerViews()
    {
        $viewPath = base_path('resources/views/modules/languagepack');

        $sourcePath = __DIR__.'/../Resources/views';

        $this->publishes([
            $sourcePath => $viewPath
        ]);

        $this->loadViewsFrom(array_merge(array_map(function ($path) {
            return $path . '/modules/languagepack';
        }, \Config::get('view.paths')), [$sourcePath]), 'languagepack');
    }

    /**
     * Register translations.
     *
     * @return void
     */
    public function registerTranslations()
    {
        $langPath = base_path('resources/lang/modules/languagepack');

        if (is_dir($langPath)) {
            $this->loadTranslationsFrom($langPath, 'languagepack');
        }
        else {
            $this->loadTranslationsFrom(__DIR__ .'/../Resources/lang', 'languagepack');
        }
    }

    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return array();
    }

}
